% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{my.acf}
\alias{my.acf}
\alias{my.ccf}
\title{Autocovariance Functions via the Discrete Fourier Transform}
\usage{
my.acf(x)

my.ccf(a, b)
}
\arguments{
\item{x, a, b}{time series}
}
\value{
The autocovariance function for all nonnegative lags or the
cross-covariance function for all lags.
}
\description{
Computes the autocovariance function (ACF) for a time series or the
cross-covariance function (CCF) between two time series.
}
\details{
The series is zero padded to twice its length before the discrete Fourier
transform is applied.  Only the values corresponding to nonnegative lags are
provided (for the ACF).
}
\examples{

data(ibm)
ibm.returns <- diff(log(ibm))
plot(1:length(ibm.returns) - 1, my.acf(ibm.returns), type="h",
     xlab="lag", ylab="ACVS", main="Autocovariance Sequence for IBM Returns")

}
\author{
B. Whitcher
}
\keyword{ts}
