% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{rotate}
\alias{rotate}
\title{Rotate cell text}
\usage{
rotate(x, i = NULL, j = NULL, rotation, align = NULL, part = "body")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{j}{column selector, see section \emph{Column selection with the \code{j} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{rotation}{one of "lrtb", "tbrl", "btlr".}

\item{align}{vertical alignment of paragraph within cell,
one of "center" or "top" or "bottom".}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' can be used.}
}
\description{
It can be useful to change the text direction
when table headers are large. For example, header labels can
be rendered as "tbrl" (top to bottom and right to left), corresponding
to a 90-degree rotation, or "btlr", corresponding to a 270-degree
rotation.
This function changes cell text direction. By default, it is
"lrtb", which means from left to right and top to bottom.

'Word' and 'PowerPoint' do not handle automatic height with rotated headers.
Therefore, you need to set header heights (with the \code{\link[=height]{height()}} function)
and set the rule to "exact" for row heights (with the \code{\link[=hrule]{hrule()}} function);
otherwise, Word and PowerPoint outputs will have insufficient height
to properly display the text.

flextable does not rotate text by arbitrary angles. It only
rotates by right angles (90-degree increments). This choice ensures
consistent rendering across Word, PowerPoint (limited to angles 0, 270, and 90),
HTML, and PDF.
}
\details{
When the \code{\link[=autofit]{autofit()}} function is used, rotation will be
ignored. In that case, use \link{dim_pretty} and \link{width} instead
of \code{autofit()}.
}
\examples{
library(flextable)

ft_1 <- flextable(head(iris))

ft_1 <- rotate(ft_1, j = 1:4, align = "bottom", rotation = "tbrl", part = "header")
ft_1 <- rotate(ft_1, j = 5, align = "bottom", rotation = "btlr", part = "header")

# if output is docx or pptx, think about (1) set header heights
# and (2) set rule "exact" for rows heights because Word
# and PowerPoint don't handle auto height with rotated headers
ft_1 <- height(ft_1, height = 1.2, part = "header")
ft_1 <- hrule(ft_1, i = 1, rule = "exact", part = "header")

ft_1

dat <- data.frame(
  a = c("left-top", "left-middle", "left-bottom"),
  b = c("center-top", "center-middle", "center-bottom"),
  c = c("right-top", "right-middle", "right-bottom")
)

ft_2 <- flextable(dat)
ft_2 <- theme_box(ft_2)
ft_2 <- height_all(x = ft_2, height = 1.3, part = "body")
ft_2 <- hrule(ft_2, rule = "exact")
ft_2 <- rotate(ft_2, rotation = "tbrl")
ft_2 <- width(ft_2, width = 1.3)

ft_2 <- align(ft_2, j = 1, align = "left")
ft_2 <- align(ft_2, j = 2, align = "center")
ft_2 <- align(ft_2, j = 3, align = "right")

ft_2 <- valign(ft_2, i = 1, valign = "top")
ft_2 <- valign(ft_2, i = 2, valign = "center")
ft_2 <- valign(ft_2, i = 3, valign = "bottom")

ft_2
}
\seealso{
Other sugar functions for table style: 
\code{\link{align}()},
\code{\link{bg}()},
\code{\link{bold}()},
\code{\link{color}()},
\code{\link{empty_blanks}()},
\code{\link{font}()},
\code{\link{fontsize}()},
\code{\link{highlight}()},
\code{\link{italic}()},
\code{\link{keep_with_next}()},
\code{\link{line_spacing}()},
\code{\link{padding}()},
\code{\link{style}()},
\code{\link{tab_settings}()},
\code{\link{valign}()}
}
\concept{sugar functions for table style}
