% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution.R
\name{has_symmetry}
\alias{has_symmetry}
\title{Check if a distribution is symmetric}
\usage{
has_symmetry(x, ...)
}
\arguments{
\item{x}{The distribution(s).}

\item{...}{Additional arguments used by methods.}
}
\value{
A logical value indicating whether the distribution is symmetric.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Determines whether a probability distribution is symmetric around its center.
}
\examples{
# Normal distribution is symmetric
has_symmetry(dist_normal(mu = 0, sigma = 1))
has_symmetry(dist_normal(mu = 5, sigma = 2))

# Beta distribution symmetry depends on parameters
has_symmetry(dist_beta(shape1 = 2, shape2 = 2))  # symmetric
has_symmetry(dist_beta(shape1 = 2, shape2 = 5))  # not symmetric

}
