# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.datamigration import DataMigrationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataMigrationManagementDatabaseMigrationsMongoToCosmosDbRUMongoOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataMigrationManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_database_migrations_mongo_to_cosmos_db_ru_mongo_get(self, resource_group):
        response = self.client.database_migrations_mongo_to_cosmos_db_ru_mongo.get(
            resource_group_name=resource_group.name,
            target_resource_name="str",
            migration_name="str",
            api_version="2025-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_database_migrations_mongo_to_cosmos_db_ru_mongo_begin_create(self, resource_group):
        response = self.client.database_migrations_mongo_to_cosmos_db_ru_mongo.begin_create(
            resource_group_name=resource_group.name,
            target_resource_name="str",
            migration_name="str",
            parameters={
                "collectionList": [
                    {
                        "migrationProgressDetails": {
                            "durationInSeconds": 0,
                            "migrationError": "str",
                            "migrationStatus": "str",
                            "processedDocumentCount": 0,
                            "sourceDocumentCount": 0,
                        },
                        "sourceCollection": "str",
                        "sourceDatabase": "str",
                        "targetCollection": "str",
                        "targetDatabase": "str",
                    }
                ],
                "endedOn": "2020-02-20 00:00:00",
                "id": "str",
                "migrationFailureError": {"code": "str", "message": "str"},
                "migrationOperationId": "str",
                "migrationService": "str",
                "migrationStatus": "str",
                "name": "str",
                "provisioningError": "str",
                "provisioningState": "str",
                "scope": "str",
                "sourceMongoConnection": {
                    "connectionString": "str",
                    "host": "str",
                    "password": "str",
                    "port": 0,
                    "useSsl": bool,
                    "userName": "str",
                },
                "startedOn": "2020-02-20 00:00:00",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "targetMongoConnection": {
                    "connectionString": "str",
                    "host": "str",
                    "password": "str",
                    "port": 0,
                    "useSsl": bool,
                    "userName": "str",
                },
                "type": "str",
            },
            api_version="2025-06-30",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_database_migrations_mongo_to_cosmos_db_ru_mongo_begin_delete(self, resource_group):
        response = self.client.database_migrations_mongo_to_cosmos_db_ru_mongo.begin_delete(
            resource_group_name=resource_group.name,
            target_resource_name="str",
            migration_name="str",
            api_version="2025-06-30",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_database_migrations_mongo_to_cosmos_db_ru_mongo_get_for_scope(self, resource_group):
        response = self.client.database_migrations_mongo_to_cosmos_db_ru_mongo.get_for_scope(
            resource_group_name=resource_group.name,
            target_resource_name="str",
            api_version="2025-06-30",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
