//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armvisualstudio

// AccountResource - The response to an account resource GET request.
type AccountResource struct {
	// Resource location.
	Location *string

	// Resource properties.
	Properties map[string]*string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Unique identifier of the resource.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// AccountResourceListResult - The response to an account resource list GET request.
type AccountResourceListResult struct {
	// Array of resource details.
	Value []*AccountResource
}

// AccountResourceRequest - The body of a PUT request to modify a Visual Studio account resource.
type AccountResourceRequest struct {
	// The account name.
	AccountName *string

	// The Azure instance location.
	Location *string

	// The type of the operation.
	OperationType *AccountResourceRequestOperationType

	// The custom properties of the resource.
	Properties map[string]*string

	// The custom tags of the resource.
	Tags map[string]*string
}

// AccountTagRequest - The body of a Patch request to add tags to a Visual Studio account resource.
type AccountTagRequest struct {
	// The custom tags of the resource.
	Tags map[string]*string
}

// CheckNameAvailabilityParameter - The body of a POST request to check name availability.
type CheckNameAvailabilityParameter struct {
	// The name of the resource to check availability for.
	ResourceName *string

	// The type of resource to check availability for.
	ResourceType *string
}

// CheckNameAvailabilityResult - The response to a name availability request.
type CheckNameAvailabilityResult struct {
	// The message describing the detailed reason.
	Message *string

	// The value which indicates whether the provided name is available.
	NameAvailable *bool
}

// ExtensionResource - The response to an extension resource GET request.
type ExtensionResource struct {
	// Resource location.
	Location *string

	// The extension plan that was purchased.
	Plan *ExtensionResourcePlan

	// Resource properties.
	Properties map[string]*string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Unique identifier of the resource.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ExtensionResourceListResult - The response to an extension resource list GET request.
type ExtensionResourceListResult struct {
	// Array of extension resource details.
	Value []*ExtensionResource
}

// ExtensionResourcePlan - Plan data for an extension resource.
type ExtensionResourcePlan struct {
	// Name of the plan.
	Name *string

	// Product name.
	Product *string

	// Optional: the promotion code associated with the plan.
	PromotionCode *string

	// Name of the extension publisher.
	Publisher *string

	// A string that uniquely identifies the plan version.
	Version *string
}

// ExtensionResourceRequest - The body of an extension resource PUT request.
type ExtensionResourceRequest struct {
	// The Azure region of the Visual Studio account associated with this request (i.e 'southcentralus'.)
	Location *string

	// Extended information about the plan being purchased for this extension resource.
	Plan *ExtensionResourcePlan

	// A dictionary of extended properties. This property is currently unused.
	Properties map[string]*string

	// A dictionary of user-defined tags to be stored with the extension resource.
	Tags map[string]*string
}

// Operation - Properties of an operation supported by the resource provider.
type Operation struct {
	// The properties of the resource operation.
	Display *OperationProperties

	// The name of the resource operation.
	Name *string
}

// OperationListResult - Container for a list of operations supported by a resource provider.
type OperationListResult struct {
	// A list of operations supported by a resource provider.
	Value []*Operation
}

// OperationProperties - Properties of an operation supported by the resource provider.
type OperationProperties struct {
	// The description of the resource operation.
	Description *string

	// The operation name.
	Operation *string

	// The provider name.
	Provider *string

	// The resource name.
	Resource *string
}

// ProjectResource - A Visual Studio Team Services project resource.
type ProjectResource struct {
	// Resource location.
	Location *string

	// Key/value pair of resource properties.
	Properties map[string]*string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Unique identifier of the resource.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ProjectResourceListResult - The response to a request to list Team Services project resources in a resource group/account.
type ProjectResourceListResult struct {
	// List of project resource details.
	Value []*ProjectResource
}

// Resource - A generic Azure Resource Manager resource.
type Resource struct {
	// Resource location.
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Unique identifier of the resource.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}
