//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armvideoanalyzer

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// VideoAnalyzersClient contains the methods for the VideoAnalyzers group.
// Don't use this type directly, use NewVideoAnalyzersClient() instead.
type VideoAnalyzersClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewVideoAnalyzersClient creates a new instance of VideoAnalyzersClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewVideoAnalyzersClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*VideoAnalyzersClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &VideoAnalyzersClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Create or update an instance of a Video Analyzer account
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// accountName - The Video Analyzer account name.
// parameters - The request parameters
// options - VideoAnalyzersClientBeginCreateOrUpdateOptions contains the optional parameters for the VideoAnalyzersClient.BeginCreateOrUpdate
// method.
func (client *VideoAnalyzersClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, parameters VideoAnalyzer, options *VideoAnalyzersClientBeginCreateOrUpdateOptions) (*runtime.Poller[VideoAnalyzersClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, accountName, parameters, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[VideoAnalyzersClientCreateOrUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[VideoAnalyzersClientCreateOrUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdate - Create or update an instance of a Video Analyzer account
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01-preview
func (client *VideoAnalyzersClient) createOrUpdate(ctx context.Context, resourceGroupName string, accountName string, parameters VideoAnalyzer, options *VideoAnalyzersClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, accountName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *VideoAnalyzersClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, accountName string, parameters VideoAnalyzer, options *VideoAnalyzersClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// Delete - Delete the specified Video Analyzer account
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// accountName - The Video Analyzer account name.
// options - VideoAnalyzersClientDeleteOptions contains the optional parameters for the VideoAnalyzersClient.Delete method.
func (client *VideoAnalyzersClient) Delete(ctx context.Context, resourceGroupName string, accountName string, options *VideoAnalyzersClientDeleteOptions) (VideoAnalyzersClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, accountName, options)
	if err != nil {
		return VideoAnalyzersClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return VideoAnalyzersClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return VideoAnalyzersClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return VideoAnalyzersClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *VideoAnalyzersClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, accountName string, options *VideoAnalyzersClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get the details of the specified Video Analyzer account
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// accountName - The Video Analyzer account name.
// options - VideoAnalyzersClientGetOptions contains the optional parameters for the VideoAnalyzersClient.Get method.
func (client *VideoAnalyzersClient) Get(ctx context.Context, resourceGroupName string, accountName string, options *VideoAnalyzersClientGetOptions) (VideoAnalyzersClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, accountName, options)
	if err != nil {
		return VideoAnalyzersClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return VideoAnalyzersClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return VideoAnalyzersClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *VideoAnalyzersClient) getCreateRequest(ctx context.Context, resourceGroupName string, accountName string, options *VideoAnalyzersClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *VideoAnalyzersClient) getHandleResponse(resp *http.Response) (VideoAnalyzersClientGetResponse, error) {
	result := VideoAnalyzersClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VideoAnalyzer); err != nil {
		return VideoAnalyzersClientGetResponse{}, err
	}
	return result, nil
}

// List - Lists the Video Analyzer accounts in the specified resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// options - VideoAnalyzersClientListOptions contains the optional parameters for the VideoAnalyzersClient.List method.
func (client *VideoAnalyzersClient) List(ctx context.Context, resourceGroupName string, options *VideoAnalyzersClientListOptions) (VideoAnalyzersClientListResponse, error) {
	req, err := client.listCreateRequest(ctx, resourceGroupName, options)
	if err != nil {
		return VideoAnalyzersClientListResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return VideoAnalyzersClientListResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return VideoAnalyzersClientListResponse{}, runtime.NewResponseError(resp)
	}
	return client.listHandleResponse(resp)
}

// listCreateRequest creates the List request.
func (client *VideoAnalyzersClient) listCreateRequest(ctx context.Context, resourceGroupName string, options *VideoAnalyzersClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *VideoAnalyzersClient) listHandleResponse(resp *http.Response) (VideoAnalyzersClientListResponse, error) {
	result := VideoAnalyzersClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Collection); err != nil {
		return VideoAnalyzersClientListResponse{}, err
	}
	return result, nil
}

// ListBySubscription - List all Video Analyzer accounts in the specified subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01-preview
// options - VideoAnalyzersClientListBySubscriptionOptions contains the optional parameters for the VideoAnalyzersClient.ListBySubscription
// method.
func (client *VideoAnalyzersClient) ListBySubscription(ctx context.Context, options *VideoAnalyzersClientListBySubscriptionOptions) (VideoAnalyzersClientListBySubscriptionResponse, error) {
	req, err := client.listBySubscriptionCreateRequest(ctx, options)
	if err != nil {
		return VideoAnalyzersClientListBySubscriptionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return VideoAnalyzersClientListBySubscriptionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return VideoAnalyzersClientListBySubscriptionResponse{}, runtime.NewResponseError(resp)
	}
	return client.listBySubscriptionHandleResponse(resp)
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *VideoAnalyzersClient) listBySubscriptionCreateRequest(ctx context.Context, options *VideoAnalyzersClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Media/videoAnalyzers"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *VideoAnalyzersClient) listBySubscriptionHandleResponse(resp *http.Response) (VideoAnalyzersClientListBySubscriptionResponse, error) {
	result := VideoAnalyzersClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Collection); err != nil {
		return VideoAnalyzersClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// BeginUpdate - Updates an existing instance of Video Analyzer account
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// accountName - The Video Analyzer account name.
// parameters - The request parameters
// options - VideoAnalyzersClientBeginUpdateOptions contains the optional parameters for the VideoAnalyzersClient.BeginUpdate
// method.
func (client *VideoAnalyzersClient) BeginUpdate(ctx context.Context, resourceGroupName string, accountName string, parameters Update, options *VideoAnalyzersClientBeginUpdateOptions) (*runtime.Poller[VideoAnalyzersClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, resourceGroupName, accountName, parameters, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[VideoAnalyzersClientUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[VideoAnalyzersClientUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// Update - Updates an existing instance of Video Analyzer account
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01-preview
func (client *VideoAnalyzersClient) update(ctx context.Context, resourceGroupName string, accountName string, parameters Update, options *VideoAnalyzersClientBeginUpdateOptions) (*http.Response, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, accountName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// updateCreateRequest creates the Update request.
func (client *VideoAnalyzersClient) updateCreateRequest(ctx context.Context, resourceGroupName string, accountName string, parameters Update, options *VideoAnalyzersClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}
