//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armscheduler

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type BasicAuthentication.
func (b BasicAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "password", b.Password)
	objectMap["type"] = HTTPAuthenticationTypeBasic
	populate(objectMap, "username", b.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BasicAuthentication.
func (b *BasicAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "password":
			err = unpopulate(val, "Password", &b.Password)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &b.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClientCertAuthentication.
func (c ClientCertAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "certificateExpirationDate", c.CertificateExpirationDate)
	populate(objectMap, "certificateSubjectName", c.CertificateSubjectName)
	populate(objectMap, "certificateThumbprint", c.CertificateThumbprint)
	populate(objectMap, "password", c.Password)
	populate(objectMap, "pfx", c.Pfx)
	objectMap["type"] = HTTPAuthenticationTypeClientCertificate
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientCertAuthentication.
func (c *ClientCertAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateExpirationDate":
			err = unpopulateDateTimeRFC3339(val, "CertificateExpirationDate", &c.CertificateExpirationDate)
			delete(rawMsg, key)
		case "certificateSubjectName":
			err = unpopulate(val, "CertificateSubjectName", &c.CertificateSubjectName)
			delete(rawMsg, key)
		case "certificateThumbprint":
			err = unpopulate(val, "CertificateThumbprint", &c.CertificateThumbprint)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &c.Password)
			delete(rawMsg, key)
		case "pfx":
			err = unpopulate(val, "Pfx", &c.Pfx)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPAuthentication.
func (h HTTPAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = h.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPAuthentication.
func (h *HTTPAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPRequest.
func (h HTTPRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authentication", h.Authentication)
	populate(objectMap, "body", h.Body)
	populate(objectMap, "headers", h.Headers)
	populate(objectMap, "method", h.Method)
	populate(objectMap, "uri", h.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPRequest.
func (h *HTTPRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authentication":
			h.Authentication, err = unmarshalHTTPAuthenticationClassification(val)
			delete(rawMsg, key)
		case "body":
			err = unpopulate(val, "Body", &h.Body)
			delete(rawMsg, key)
		case "headers":
			err = unpopulate(val, "Headers", &h.Headers)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &h.Method)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &h.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobAction.
func (j JobAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorAction", j.ErrorAction)
	populate(objectMap, "queueMessage", j.QueueMessage)
	populate(objectMap, "request", j.Request)
	populate(objectMap, "retryPolicy", j.RetryPolicy)
	populate(objectMap, "serviceBusQueueMessage", j.ServiceBusQueueMessage)
	populate(objectMap, "serviceBusTopicMessage", j.ServiceBusTopicMessage)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobAction.
func (j *JobAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorAction":
			err = unpopulate(val, "ErrorAction", &j.ErrorAction)
			delete(rawMsg, key)
		case "queueMessage":
			err = unpopulate(val, "QueueMessage", &j.QueueMessage)
			delete(rawMsg, key)
		case "request":
			err = unpopulate(val, "Request", &j.Request)
			delete(rawMsg, key)
		case "retryPolicy":
			err = unpopulate(val, "RetryPolicy", &j.RetryPolicy)
			delete(rawMsg, key)
		case "serviceBusQueueMessage":
			err = unpopulate(val, "ServiceBusQueueMessage", &j.ServiceBusQueueMessage)
			delete(rawMsg, key)
		case "serviceBusTopicMessage":
			err = unpopulate(val, "ServiceBusTopicMessage", &j.ServiceBusTopicMessage)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobCollectionDefinition.
func (j JobCollectionDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", j.ID)
	populate(objectMap, "location", j.Location)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "tags", j.Tags)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobCollectionDefinition.
func (j *JobCollectionDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &j.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &j.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobCollectionListResult.
func (j JobCollectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", j.NextLink)
	populate(objectMap, "value", j.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobCollectionListResult.
func (j *JobCollectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &j.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &j.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobCollectionProperties.
func (j JobCollectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "quota", j.Quota)
	populate(objectMap, "sku", j.SKU)
	populate(objectMap, "state", j.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobCollectionProperties.
func (j *JobCollectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "quota":
			err = unpopulate(val, "Quota", &j.Quota)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &j.SKU)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &j.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobCollectionQuota.
func (j JobCollectionQuota) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxJobCount", j.MaxJobCount)
	populate(objectMap, "maxJobOccurrence", j.MaxJobOccurrence)
	populate(objectMap, "maxRecurrence", j.MaxRecurrence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobCollectionQuota.
func (j *JobCollectionQuota) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxJobCount":
			err = unpopulate(val, "MaxJobCount", &j.MaxJobCount)
			delete(rawMsg, key)
		case "maxJobOccurrence":
			err = unpopulate(val, "MaxJobOccurrence", &j.MaxJobOccurrence)
			delete(rawMsg, key)
		case "maxRecurrence":
			err = unpopulate(val, "MaxRecurrence", &j.MaxRecurrence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobDefinition.
func (j JobDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", j.ID)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobDefinition.
func (j *JobDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobErrorAction.
func (j JobErrorAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "queueMessage", j.QueueMessage)
	populate(objectMap, "request", j.Request)
	populate(objectMap, "retryPolicy", j.RetryPolicy)
	populate(objectMap, "serviceBusQueueMessage", j.ServiceBusQueueMessage)
	populate(objectMap, "serviceBusTopicMessage", j.ServiceBusTopicMessage)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobErrorAction.
func (j *JobErrorAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "queueMessage":
			err = unpopulate(val, "QueueMessage", &j.QueueMessage)
			delete(rawMsg, key)
		case "request":
			err = unpopulate(val, "Request", &j.Request)
			delete(rawMsg, key)
		case "retryPolicy":
			err = unpopulate(val, "RetryPolicy", &j.RetryPolicy)
			delete(rawMsg, key)
		case "serviceBusQueueMessage":
			err = unpopulate(val, "ServiceBusQueueMessage", &j.ServiceBusQueueMessage)
			delete(rawMsg, key)
		case "serviceBusTopicMessage":
			err = unpopulate(val, "ServiceBusTopicMessage", &j.ServiceBusTopicMessage)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobHistoryDefinition.
func (j JobHistoryDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", j.ID)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobHistoryDefinition.
func (j *JobHistoryDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobHistoryDefinitionProperties.
func (j JobHistoryDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionName", j.ActionName)
	populateDateTimeRFC3339(objectMap, "endTime", j.EndTime)
	populateDateTimeRFC3339(objectMap, "expectedExecutionTime", j.ExpectedExecutionTime)
	populate(objectMap, "message", j.Message)
	populate(objectMap, "repeatCount", j.RepeatCount)
	populate(objectMap, "retryCount", j.RetryCount)
	populateDateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "status", j.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobHistoryDefinitionProperties.
func (j *JobHistoryDefinitionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionName":
			err = unpopulate(val, "ActionName", &j.ActionName)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "expectedExecutionTime":
			err = unpopulateDateTimeRFC3339(val, "ExpectedExecutionTime", &j.ExpectedExecutionTime)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &j.Message)
			delete(rawMsg, key)
		case "repeatCount":
			err = unpopulate(val, "RepeatCount", &j.RepeatCount)
			delete(rawMsg, key)
		case "retryCount":
			err = unpopulate(val, "RetryCount", &j.RetryCount)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobHistoryFilter.
func (j JobHistoryFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "status", j.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobHistoryFilter.
func (j *JobHistoryFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobHistoryListResult.
func (j JobHistoryListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", j.NextLink)
	populate(objectMap, "value", j.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobHistoryListResult.
func (j *JobHistoryListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &j.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &j.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobListResult.
func (j JobListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", j.NextLink)
	populate(objectMap, "value", j.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobListResult.
func (j *JobListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &j.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &j.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobMaxRecurrence.
func (j JobMaxRecurrence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "frequency", j.Frequency)
	populate(objectMap, "interval", j.Interval)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobMaxRecurrence.
func (j *JobMaxRecurrence) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "frequency":
			err = unpopulate(val, "Frequency", &j.Frequency)
			delete(rawMsg, key)
		case "interval":
			err = unpopulate(val, "Interval", &j.Interval)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobProperties.
func (j JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", j.Action)
	populate(objectMap, "recurrence", j.Recurrence)
	populateDateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "state", j.State)
	populate(objectMap, "status", j.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobProperties.
func (j *JobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &j.Action)
			delete(rawMsg, key)
		case "recurrence":
			err = unpopulate(val, "Recurrence", &j.Recurrence)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &j.State)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobRecurrence.
func (j JobRecurrence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", j.Count)
	populateDateTimeRFC3339(objectMap, "endTime", j.EndTime)
	populate(objectMap, "frequency", j.Frequency)
	populate(objectMap, "interval", j.Interval)
	populate(objectMap, "schedule", j.Schedule)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobRecurrence.
func (j *JobRecurrence) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &j.Count)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "frequency":
			err = unpopulate(val, "Frequency", &j.Frequency)
			delete(rawMsg, key)
		case "interval":
			err = unpopulate(val, "Interval", &j.Interval)
			delete(rawMsg, key)
		case "schedule":
			err = unpopulate(val, "Schedule", &j.Schedule)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobRecurrenceSchedule.
func (j JobRecurrenceSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hours", j.Hours)
	populate(objectMap, "minutes", j.Minutes)
	populate(objectMap, "monthDays", j.MonthDays)
	populate(objectMap, "monthlyOccurrences", j.MonthlyOccurrences)
	populate(objectMap, "weekDays", j.WeekDays)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobRecurrenceSchedule.
func (j *JobRecurrenceSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hours":
			err = unpopulate(val, "Hours", &j.Hours)
			delete(rawMsg, key)
		case "minutes":
			err = unpopulate(val, "Minutes", &j.Minutes)
			delete(rawMsg, key)
		case "monthDays":
			err = unpopulate(val, "MonthDays", &j.MonthDays)
			delete(rawMsg, key)
		case "monthlyOccurrences":
			err = unpopulate(val, "MonthlyOccurrences", &j.MonthlyOccurrences)
			delete(rawMsg, key)
		case "weekDays":
			err = unpopulate(val, "WeekDays", &j.WeekDays)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobRecurrenceScheduleMonthlyOccurrence.
func (j JobRecurrenceScheduleMonthlyOccurrence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "day", j.Day)
	populate(objectMap, "Occurrence", j.Occurrence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobRecurrenceScheduleMonthlyOccurrence.
func (j *JobRecurrenceScheduleMonthlyOccurrence) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "day":
			err = unpopulate(val, "Day", &j.Day)
			delete(rawMsg, key)
		case "Occurrence":
			err = unpopulate(val, "Occurrence", &j.Occurrence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobStateFilter.
func (j JobStateFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", j.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobStateFilter.
func (j *JobStateFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &j.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobStatus.
func (j JobStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "executionCount", j.ExecutionCount)
	populate(objectMap, "failureCount", j.FailureCount)
	populate(objectMap, "faultedCount", j.FaultedCount)
	populateDateTimeRFC3339(objectMap, "lastExecutionTime", j.LastExecutionTime)
	populateDateTimeRFC3339(objectMap, "nextExecutionTime", j.NextExecutionTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobStatus.
func (j *JobStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "executionCount":
			err = unpopulate(val, "ExecutionCount", &j.ExecutionCount)
			delete(rawMsg, key)
		case "failureCount":
			err = unpopulate(val, "FailureCount", &j.FailureCount)
			delete(rawMsg, key)
		case "faultedCount":
			err = unpopulate(val, "FaultedCount", &j.FaultedCount)
			delete(rawMsg, key)
		case "lastExecutionTime":
			err = unpopulateDateTimeRFC3339(val, "LastExecutionTime", &j.LastExecutionTime)
			delete(rawMsg, key)
		case "nextExecutionTime":
			err = unpopulateDateTimeRFC3339(val, "NextExecutionTime", &j.NextExecutionTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OAuthAuthentication.
func (o OAuthAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "audience", o.Audience)
	populate(objectMap, "clientId", o.ClientID)
	populate(objectMap, "secret", o.Secret)
	populate(objectMap, "tenant", o.Tenant)
	objectMap["type"] = HTTPAuthenticationTypeActiveDirectoryOAuth
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OAuthAuthentication.
func (o *OAuthAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "audience":
			err = unpopulate(val, "Audience", &o.Audience)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &o.ClientID)
			delete(rawMsg, key)
		case "secret":
			err = unpopulate(val, "Secret", &o.Secret)
			delete(rawMsg, key)
		case "tenant":
			err = unpopulate(val, "Tenant", &o.Tenant)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RetryPolicy.
func (r RetryPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "retryCount", r.RetryCount)
	populate(objectMap, "retryInterval", r.RetryInterval)
	populate(objectMap, "retryType", r.RetryType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RetryPolicy.
func (r *RetryPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "retryCount":
			err = unpopulate(val, "RetryCount", &r.RetryCount)
			delete(rawMsg, key)
		case "retryInterval":
			err = unpopulate(val, "RetryInterval", &r.RetryInterval)
			delete(rawMsg, key)
		case "retryType":
			err = unpopulate(val, "RetryType", &r.RetryType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusAuthentication.
func (s ServiceBusAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sasKey", s.SasKey)
	populate(objectMap, "sasKeyName", s.SasKeyName)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusAuthentication.
func (s *ServiceBusAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sasKey":
			err = unpopulate(val, "SasKey", &s.SasKey)
			delete(rawMsg, key)
		case "sasKeyName":
			err = unpopulate(val, "SasKeyName", &s.SasKeyName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusBrokeredMessageProperties.
func (s ServiceBusBrokeredMessageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentType", s.ContentType)
	populate(objectMap, "correlationId", s.CorrelationID)
	populate(objectMap, "forcePersistence", s.ForcePersistence)
	populate(objectMap, "label", s.Label)
	populate(objectMap, "messageId", s.MessageID)
	populate(objectMap, "partitionKey", s.PartitionKey)
	populate(objectMap, "replyTo", s.ReplyTo)
	populate(objectMap, "replyToSessionId", s.ReplyToSessionID)
	populateDateTimeRFC3339(objectMap, "scheduledEnqueueTimeUtc", s.ScheduledEnqueueTimeUTC)
	populate(objectMap, "sessionId", s.SessionID)
	populate(objectMap, "timeToLive", s.TimeToLive)
	populate(objectMap, "to", s.To)
	populate(objectMap, "viaPartitionKey", s.ViaPartitionKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusBrokeredMessageProperties.
func (s *ServiceBusBrokeredMessageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentType":
			err = unpopulate(val, "ContentType", &s.ContentType)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &s.CorrelationID)
			delete(rawMsg, key)
		case "forcePersistence":
			err = unpopulate(val, "ForcePersistence", &s.ForcePersistence)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &s.Label)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &s.MessageID)
			delete(rawMsg, key)
		case "partitionKey":
			err = unpopulate(val, "PartitionKey", &s.PartitionKey)
			delete(rawMsg, key)
		case "replyTo":
			err = unpopulate(val, "ReplyTo", &s.ReplyTo)
			delete(rawMsg, key)
		case "replyToSessionId":
			err = unpopulate(val, "ReplyToSessionID", &s.ReplyToSessionID)
			delete(rawMsg, key)
		case "scheduledEnqueueTimeUtc":
			err = unpopulateDateTimeRFC3339(val, "ScheduledEnqueueTimeUTC", &s.ScheduledEnqueueTimeUTC)
			delete(rawMsg, key)
		case "sessionId":
			err = unpopulate(val, "SessionID", &s.SessionID)
			delete(rawMsg, key)
		case "timeToLive":
			err = unpopulate(val, "TimeToLive", &s.TimeToLive)
			delete(rawMsg, key)
		case "to":
			err = unpopulate(val, "To", &s.To)
			delete(rawMsg, key)
		case "viaPartitionKey":
			err = unpopulate(val, "ViaPartitionKey", &s.ViaPartitionKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusMessage.
func (s ServiceBusMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authentication", s.Authentication)
	populate(objectMap, "brokeredMessageProperties", s.BrokeredMessageProperties)
	populate(objectMap, "customMessageProperties", s.CustomMessageProperties)
	populate(objectMap, "message", s.Message)
	populate(objectMap, "namespace", s.Namespace)
	populate(objectMap, "transportType", s.TransportType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusMessage.
func (s *ServiceBusMessage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authentication":
			err = unpopulate(val, "Authentication", &s.Authentication)
			delete(rawMsg, key)
		case "brokeredMessageProperties":
			err = unpopulate(val, "BrokeredMessageProperties", &s.BrokeredMessageProperties)
			delete(rawMsg, key)
		case "customMessageProperties":
			err = unpopulate(val, "CustomMessageProperties", &s.CustomMessageProperties)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &s.Message)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &s.Namespace)
			delete(rawMsg, key)
		case "transportType":
			err = unpopulate(val, "TransportType", &s.TransportType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusQueueMessage.
func (s ServiceBusQueueMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authentication", s.Authentication)
	populate(objectMap, "brokeredMessageProperties", s.BrokeredMessageProperties)
	populate(objectMap, "customMessageProperties", s.CustomMessageProperties)
	populate(objectMap, "message", s.Message)
	populate(objectMap, "namespace", s.Namespace)
	populate(objectMap, "queueName", s.QueueName)
	populate(objectMap, "transportType", s.TransportType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusQueueMessage.
func (s *ServiceBusQueueMessage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authentication":
			err = unpopulate(val, "Authentication", &s.Authentication)
			delete(rawMsg, key)
		case "brokeredMessageProperties":
			err = unpopulate(val, "BrokeredMessageProperties", &s.BrokeredMessageProperties)
			delete(rawMsg, key)
		case "customMessageProperties":
			err = unpopulate(val, "CustomMessageProperties", &s.CustomMessageProperties)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &s.Message)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &s.Namespace)
			delete(rawMsg, key)
		case "queueName":
			err = unpopulate(val, "QueueName", &s.QueueName)
			delete(rawMsg, key)
		case "transportType":
			err = unpopulate(val, "TransportType", &s.TransportType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusTopicMessage.
func (s ServiceBusTopicMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authentication", s.Authentication)
	populate(objectMap, "brokeredMessageProperties", s.BrokeredMessageProperties)
	populate(objectMap, "customMessageProperties", s.CustomMessageProperties)
	populate(objectMap, "message", s.Message)
	populate(objectMap, "namespace", s.Namespace)
	populate(objectMap, "topicPath", s.TopicPath)
	populate(objectMap, "transportType", s.TransportType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusTopicMessage.
func (s *ServiceBusTopicMessage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authentication":
			err = unpopulate(val, "Authentication", &s.Authentication)
			delete(rawMsg, key)
		case "brokeredMessageProperties":
			err = unpopulate(val, "BrokeredMessageProperties", &s.BrokeredMessageProperties)
			delete(rawMsg, key)
		case "customMessageProperties":
			err = unpopulate(val, "CustomMessageProperties", &s.CustomMessageProperties)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &s.Message)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &s.Namespace)
			delete(rawMsg, key)
		case "topicPath":
			err = unpopulate(val, "TopicPath", &s.TopicPath)
			delete(rawMsg, key)
		case "transportType":
			err = unpopulate(val, "TransportType", &s.TransportType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageQueueMessage.
func (s StorageQueueMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", s.Message)
	populate(objectMap, "queueName", s.QueueName)
	populate(objectMap, "sasToken", s.SasToken)
	populate(objectMap, "storageAccount", s.StorageAccount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageQueueMessage.
func (s *StorageQueueMessage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &s.Message)
			delete(rawMsg, key)
		case "queueName":
			err = unpopulate(val, "QueueName", &s.QueueName)
			delete(rawMsg, key)
		case "sasToken":
			err = unpopulate(val, "SasToken", &s.SasToken)
			delete(rawMsg, key)
		case "storageAccount":
			err = unpopulate(val, "StorageAccount", &s.StorageAccount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
