//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armresourcehealth

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AvailabilityStatus.
func (a AvailabilityStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilityStatus.
func (a *AvailabilityStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilityStatusListResult.
func (a AvailabilityStatusListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilityStatusListResult.
func (a *AvailabilityStatusListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilityStatusProperties.
func (a AvailabilityStatusProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "articleId", a.ArticleID)
	populate(objectMap, "availabilityState", a.AvailabilityState)
	populate(objectMap, "category", a.Category)
	populate(objectMap, "context", a.Context)
	populate(objectMap, "detailedStatus", a.DetailedStatus)
	populate(objectMap, "healthEventCategory", a.HealthEventCategory)
	populate(objectMap, "healthEventCause", a.HealthEventCause)
	populate(objectMap, "healthEventId", a.HealthEventID)
	populate(objectMap, "healthEventType", a.HealthEventType)
	populateDateTimeRFC3339(objectMap, "occuredTime", a.OccurredTime)
	populate(objectMap, "reasonChronicity", a.ReasonChronicity)
	populate(objectMap, "reasonType", a.ReasonType)
	populate(objectMap, "recentlyResolved", a.RecentlyResolved)
	populate(objectMap, "recommendedActions", a.RecommendedActions)
	populateDateTimeRFC3339(objectMap, "reportedTime", a.ReportedTime)
	populateDateTimeRFC3339(objectMap, "resolutionETA", a.ResolutionETA)
	populateDateTimeRFC3339(objectMap, "rootCauseAttributionTime", a.RootCauseAttributionTime)
	populate(objectMap, "serviceImpactingEvents", a.ServiceImpactingEvents)
	populate(objectMap, "summary", a.Summary)
	populate(objectMap, "title", a.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilityStatusProperties.
func (a *AvailabilityStatusProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "articleId":
			err = unpopulate(val, "ArticleID", &a.ArticleID)
			delete(rawMsg, key)
		case "availabilityState":
			err = unpopulate(val, "AvailabilityState", &a.AvailabilityState)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &a.Category)
			delete(rawMsg, key)
		case "context":
			err = unpopulate(val, "Context", &a.Context)
			delete(rawMsg, key)
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &a.DetailedStatus)
			delete(rawMsg, key)
		case "healthEventCategory":
			err = unpopulate(val, "HealthEventCategory", &a.HealthEventCategory)
			delete(rawMsg, key)
		case "healthEventCause":
			err = unpopulate(val, "HealthEventCause", &a.HealthEventCause)
			delete(rawMsg, key)
		case "healthEventId":
			err = unpopulate(val, "HealthEventID", &a.HealthEventID)
			delete(rawMsg, key)
		case "healthEventType":
			err = unpopulate(val, "HealthEventType", &a.HealthEventType)
			delete(rawMsg, key)
		case "occuredTime":
			err = unpopulateDateTimeRFC3339(val, "OccurredTime", &a.OccurredTime)
			delete(rawMsg, key)
		case "reasonChronicity":
			err = unpopulate(val, "ReasonChronicity", &a.ReasonChronicity)
			delete(rawMsg, key)
		case "reasonType":
			err = unpopulate(val, "ReasonType", &a.ReasonType)
			delete(rawMsg, key)
		case "recentlyResolved":
			err = unpopulate(val, "RecentlyResolved", &a.RecentlyResolved)
			delete(rawMsg, key)
		case "recommendedActions":
			err = unpopulate(val, "RecommendedActions", &a.RecommendedActions)
			delete(rawMsg, key)
		case "reportedTime":
			err = unpopulateDateTimeRFC3339(val, "ReportedTime", &a.ReportedTime)
			delete(rawMsg, key)
		case "resolutionETA":
			err = unpopulateDateTimeRFC3339(val, "ResolutionETA", &a.ResolutionETA)
			delete(rawMsg, key)
		case "rootCauseAttributionTime":
			err = unpopulateDateTimeRFC3339(val, "RootCauseAttributionTime", &a.RootCauseAttributionTime)
			delete(rawMsg, key)
		case "serviceImpactingEvents":
			err = unpopulate(val, "ServiceImpactingEvents", &a.ServiceImpactingEvents)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &a.Summary)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &a.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilityStatusPropertiesRecentlyResolved.
func (a AvailabilityStatusPropertiesRecentlyResolved) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "resolvedTime", a.ResolvedTime)
	populate(objectMap, "unavailableSummary", a.UnavailabilitySummary)
	populateDateTimeRFC3339(objectMap, "unavailableOccuredTime", a.UnavailableOccurredTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilityStatusPropertiesRecentlyResolved.
func (a *AvailabilityStatusPropertiesRecentlyResolved) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resolvedTime":
			err = unpopulateDateTimeRFC3339(val, "ResolvedTime", &a.ResolvedTime)
			delete(rawMsg, key)
		case "unavailableSummary":
			err = unpopulate(val, "UnavailabilitySummary", &a.UnavailabilitySummary)
			delete(rawMsg, key)
		case "unavailableOccuredTime":
			err = unpopulateDateTimeRFC3339(val, "UnavailableOccurredTime", &a.UnavailableOccurredTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmergingIssue.
func (e EmergingIssue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "refreshTimestamp", e.RefreshTimestamp)
	populate(objectMap, "statusActiveEvents", e.StatusActiveEvents)
	populate(objectMap, "statusBanners", e.StatusBanners)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmergingIssue.
func (e *EmergingIssue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "refreshTimestamp":
			err = unpopulateDateTimeRFC3339(val, "RefreshTimestamp", &e.RefreshTimestamp)
			delete(rawMsg, key)
		case "statusActiveEvents":
			err = unpopulate(val, "StatusActiveEvents", &e.StatusActiveEvents)
			delete(rawMsg, key)
		case "statusBanners":
			err = unpopulate(val, "StatusBanners", &e.StatusBanners)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmergingIssueImpact.
func (e EmergingIssueImpact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "regions", e.Regions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmergingIssueImpact.
func (e *EmergingIssueImpact) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "regions":
			err = unpopulate(val, "Regions", &e.Regions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmergingIssueListResult.
func (e EmergingIssueListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmergingIssueListResult.
func (e *EmergingIssueListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmergingIssuesGetResult.
func (e EmergingIssuesGetResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmergingIssuesGetResult.
func (e *EmergingIssuesGetResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &e.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Event.
func (e Event) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Event.
func (e *Event) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &e.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventImpactedResource.
func (e EventImpactedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventImpactedResource.
func (e *EventImpactedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &e.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventImpactedResourceListResult.
func (e EventImpactedResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventImpactedResourceListResult.
func (e *EventImpactedResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventImpactedResourceProperties.
func (e EventImpactedResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "info", e.Info)
	populate(objectMap, "maintenanceEndTime", e.MaintenanceEndTime)
	populate(objectMap, "maintenanceStartTime", e.MaintenanceStartTime)
	populate(objectMap, "resourceGroup", e.ResourceGroup)
	populate(objectMap, "resourceName", e.ResourceName)
	populate(objectMap, "status", e.Status)
	populate(objectMap, "targetRegion", e.TargetRegion)
	populate(objectMap, "targetResourceId", e.TargetResourceID)
	populate(objectMap, "targetResourceType", e.TargetResourceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventImpactedResourceProperties.
func (e *EventImpactedResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &e.Info)
			delete(rawMsg, key)
		case "maintenanceEndTime":
			err = unpopulate(val, "MaintenanceEndTime", &e.MaintenanceEndTime)
			delete(rawMsg, key)
		case "maintenanceStartTime":
			err = unpopulate(val, "MaintenanceStartTime", &e.MaintenanceStartTime)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &e.ResourceGroup)
			delete(rawMsg, key)
		case "resourceName":
			err = unpopulate(val, "ResourceName", &e.ResourceName)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &e.Status)
			delete(rawMsg, key)
		case "targetRegion":
			err = unpopulate(val, "TargetRegion", &e.TargetRegion)
			delete(rawMsg, key)
		case "targetResourceId":
			err = unpopulate(val, "TargetResourceID", &e.TargetResourceID)
			delete(rawMsg, key)
		case "targetResourceType":
			err = unpopulate(val, "TargetResourceType", &e.TargetResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventProperties.
func (e EventProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInformation", e.AdditionalInformation)
	populate(objectMap, "argQuery", e.ArgQuery)
	populate(objectMap, "article", e.Article)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "duration", e.Duration)
	populate(objectMap, "enableChatWithUs", e.EnableChatWithUs)
	populate(objectMap, "enableMicrosoftSupport", e.EnableMicrosoftSupport)
	populate(objectMap, "eventLevel", e.EventLevel)
	populate(objectMap, "eventSource", e.EventSource)
	populate(objectMap, "eventSubType", e.EventSubType)
	populate(objectMap, "eventType", e.EventType)
	populate(objectMap, "externalIncidentId", e.ExternalIncidentID)
	populate(objectMap, "faqs", e.Faqs)
	populate(objectMap, "header", e.Header)
	populate(objectMap, "hirStage", e.HirStage)
	populate(objectMap, "impact", e.Impact)
	populateDateTimeRFC3339(objectMap, "impactMitigationTime", e.ImpactMitigationTime)
	populateDateTimeRFC3339(objectMap, "impactStartTime", e.ImpactStartTime)
	populate(objectMap, "impactType", e.ImpactType)
	populate(objectMap, "isHIR", e.IsHIR)
	populateDateTimeRFC3339(objectMap, "lastUpdateTime", e.LastUpdateTime)
	populate(objectMap, "level", e.Level)
	populate(objectMap, "links", e.Links)
	populate(objectMap, "maintenanceId", e.MaintenanceID)
	populate(objectMap, "maintenanceType", e.MaintenanceType)
	populate(objectMap, "platformInitiated", e.PlatformInitiated)
	populate(objectMap, "priority", e.Priority)
	populate(objectMap, "reason", e.Reason)
	populate(objectMap, "recommendedActions", e.RecommendedActions)
	populate(objectMap, "status", e.Status)
	populate(objectMap, "summary", e.Summary)
	populate(objectMap, "title", e.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventProperties.
func (e *EventProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInformation":
			err = unpopulate(val, "AdditionalInformation", &e.AdditionalInformation)
			delete(rawMsg, key)
		case "argQuery":
			err = unpopulate(val, "ArgQuery", &e.ArgQuery)
			delete(rawMsg, key)
		case "article":
			err = unpopulate(val, "Article", &e.Article)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "duration":
			err = unpopulate(val, "Duration", &e.Duration)
			delete(rawMsg, key)
		case "enableChatWithUs":
			err = unpopulate(val, "EnableChatWithUs", &e.EnableChatWithUs)
			delete(rawMsg, key)
		case "enableMicrosoftSupport":
			err = unpopulate(val, "EnableMicrosoftSupport", &e.EnableMicrosoftSupport)
			delete(rawMsg, key)
		case "eventLevel":
			err = unpopulate(val, "EventLevel", &e.EventLevel)
			delete(rawMsg, key)
		case "eventSource":
			err = unpopulate(val, "EventSource", &e.EventSource)
			delete(rawMsg, key)
		case "eventSubType":
			err = unpopulate(val, "EventSubType", &e.EventSubType)
			delete(rawMsg, key)
		case "eventType":
			err = unpopulate(val, "EventType", &e.EventType)
			delete(rawMsg, key)
		case "externalIncidentId":
			err = unpopulate(val, "ExternalIncidentID", &e.ExternalIncidentID)
			delete(rawMsg, key)
		case "faqs":
			err = unpopulate(val, "Faqs", &e.Faqs)
			delete(rawMsg, key)
		case "header":
			err = unpopulate(val, "Header", &e.Header)
			delete(rawMsg, key)
		case "hirStage":
			err = unpopulate(val, "HirStage", &e.HirStage)
			delete(rawMsg, key)
		case "impact":
			err = unpopulate(val, "Impact", &e.Impact)
			delete(rawMsg, key)
		case "impactMitigationTime":
			err = unpopulateDateTimeRFC3339(val, "ImpactMitigationTime", &e.ImpactMitigationTime)
			delete(rawMsg, key)
		case "impactStartTime":
			err = unpopulateDateTimeRFC3339(val, "ImpactStartTime", &e.ImpactStartTime)
			delete(rawMsg, key)
		case "impactType":
			err = unpopulate(val, "ImpactType", &e.ImpactType)
			delete(rawMsg, key)
		case "isHIR":
			err = unpopulate(val, "IsHIR", &e.IsHIR)
			delete(rawMsg, key)
		case "lastUpdateTime":
			err = unpopulateDateTimeRFC3339(val, "LastUpdateTime", &e.LastUpdateTime)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, "Level", &e.Level)
			delete(rawMsg, key)
		case "links":
			err = unpopulate(val, "Links", &e.Links)
			delete(rawMsg, key)
		case "maintenanceId":
			err = unpopulate(val, "MaintenanceID", &e.MaintenanceID)
			delete(rawMsg, key)
		case "maintenanceType":
			err = unpopulate(val, "MaintenanceType", &e.MaintenanceType)
			delete(rawMsg, key)
		case "platformInitiated":
			err = unpopulate(val, "PlatformInitiated", &e.PlatformInitiated)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &e.Priority)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &e.Reason)
			delete(rawMsg, key)
		case "recommendedActions":
			err = unpopulate(val, "RecommendedActions", &e.RecommendedActions)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &e.Status)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &e.Summary)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &e.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventPropertiesAdditionalInformation.
func (e EventPropertiesAdditionalInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventPropertiesAdditionalInformation.
func (e *EventPropertiesAdditionalInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventPropertiesArticle.
func (e EventPropertiesArticle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "articleContent", e.ArticleContent)
	populate(objectMap, "articleId", e.ArticleID)
	populateAny(objectMap, "parameters", e.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventPropertiesArticle.
func (e *EventPropertiesArticle) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "articleContent":
			err = unpopulate(val, "ArticleContent", &e.ArticleContent)
			delete(rawMsg, key)
		case "articleId":
			err = unpopulate(val, "ArticleID", &e.ArticleID)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &e.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventPropertiesRecommendedActions.
func (e EventPropertiesRecommendedActions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", e.Actions)
	populate(objectMap, "localeCode", e.LocaleCode)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventPropertiesRecommendedActions.
func (e *EventPropertiesRecommendedActions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &e.Actions)
			delete(rawMsg, key)
		case "localeCode":
			err = unpopulate(val, "LocaleCode", &e.LocaleCode)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventPropertiesRecommendedActionsItem.
func (e EventPropertiesRecommendedActionsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionText", e.ActionText)
	populate(objectMap, "groupId", e.GroupID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventPropertiesRecommendedActionsItem.
func (e *EventPropertiesRecommendedActionsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionText":
			err = unpopulate(val, "ActionText", &e.ActionText)
			delete(rawMsg, key)
		case "groupId":
			err = unpopulate(val, "GroupID", &e.GroupID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Events.
func (e Events) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Events.
func (e *Events) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Faq.
func (f Faq) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "answer", f.Answer)
	populate(objectMap, "localeCode", f.LocaleCode)
	populate(objectMap, "question", f.Question)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Faq.
func (f *Faq) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "answer":
			err = unpopulate(val, "Answer", &f.Answer)
			delete(rawMsg, key)
		case "localeCode":
			err = unpopulate(val, "LocaleCode", &f.LocaleCode)
			delete(rawMsg, key)
		case "question":
			err = unpopulate(val, "Question", &f.Question)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Impact.
func (i Impact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "impactedRegions", i.ImpactedRegions)
	populate(objectMap, "impactedService", i.ImpactedService)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Impact.
func (i *Impact) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "impactedRegions":
			err = unpopulate(val, "ImpactedRegions", &i.ImpactedRegions)
			delete(rawMsg, key)
		case "impactedService":
			err = unpopulate(val, "ImpactedService", &i.ImpactedService)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImpactedRegion.
func (i ImpactedRegion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImpactedRegion.
func (i *ImpactedRegion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImpactedServiceRegion.
func (i ImpactedServiceRegion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "impactedRegion", i.ImpactedRegion)
	populate(objectMap, "impactedSubscriptions", i.ImpactedSubscriptions)
	populate(objectMap, "impactedTenants", i.ImpactedTenants)
	populateDateTimeRFC3339(objectMap, "lastUpdateTime", i.LastUpdateTime)
	populate(objectMap, "status", i.Status)
	populate(objectMap, "updates", i.Updates)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImpactedServiceRegion.
func (i *ImpactedServiceRegion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "impactedRegion":
			err = unpopulate(val, "ImpactedRegion", &i.ImpactedRegion)
			delete(rawMsg, key)
		case "impactedSubscriptions":
			err = unpopulate(val, "ImpactedSubscriptions", &i.ImpactedSubscriptions)
			delete(rawMsg, key)
		case "impactedTenants":
			err = unpopulate(val, "ImpactedTenants", &i.ImpactedTenants)
			delete(rawMsg, key)
		case "lastUpdateTime":
			err = unpopulateDateTimeRFC3339(val, "LastUpdateTime", &i.LastUpdateTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &i.Status)
			delete(rawMsg, key)
		case "updates":
			err = unpopulate(val, "Updates", &i.Updates)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyValueItem.
func (k KeyValueItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", k.Key)
	populate(objectMap, "value", k.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyValueItem.
func (k *KeyValueItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &k.Key)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &k.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Link.
func (l Link) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bladeName", l.BladeName)
	populate(objectMap, "displayText", l.DisplayText)
	populate(objectMap, "extensionName", l.ExtensionName)
	populateAny(objectMap, "parameters", l.Parameters)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Link.
func (l *Link) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bladeName":
			err = unpopulate(val, "BladeName", &l.BladeName)
			delete(rawMsg, key)
		case "displayText":
			err = unpopulate(val, "DisplayText", &l.DisplayText)
			delete(rawMsg, key)
		case "extensionName":
			err = unpopulate(val, "ExtensionName", &l.ExtensionName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &l.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkDisplayText.
func (l LinkDisplayText) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValue", l.LocalizedValue)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkDisplayText.
func (l *LinkDisplayText) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &l.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetadataEntity.
func (m MetadataEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetadataEntity.
func (m *MetadataEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetadataEntityListResult.
func (m MetadataEntityListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetadataEntityListResult.
func (m *MetadataEntityListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetadataEntityProperties.
func (m MetadataEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicableScenarios", m.ApplicableScenarios)
	populate(objectMap, "dependsOn", m.DependsOn)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "supportedValues", m.SupportedValues)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetadataEntityProperties.
func (m *MetadataEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicableScenarios":
			err = unpopulate(val, "ApplicableScenarios", &m.ApplicableScenarios)
			delete(rawMsg, key)
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &m.DependsOn)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "supportedValues":
			err = unpopulate(val, "SupportedValues", &m.SupportedValues)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetadataSupportedValueDetail.
func (m MetadataSupportedValueDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "resourceTypes", m.ResourceTypes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetadataSupportedValueDetail.
func (m *MetadataSupportedValueDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "resourceTypes":
			err = unpopulate(val, "ResourceTypes", &m.ResourceTypes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecommendedAction.
func (r RecommendedAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", r.Action)
	populate(objectMap, "actionUrl", r.ActionURL)
	populate(objectMap, "_ActionUrl.Comment", r.ActionURLComment)
	populate(objectMap, "actionUrlText", r.ActionURLText)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecommendedAction.
func (r *RecommendedAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &r.Action)
			delete(rawMsg, key)
		case "actionUrl":
			err = unpopulate(val, "ActionURL", &r.ActionURL)
			delete(rawMsg, key)
		case "_ActionUrl.Comment":
			err = unpopulate(val, "ActionURLComment", &r.ActionURLComment)
			delete(rawMsg, key)
		case "actionUrlText":
			err = unpopulate(val, "ActionURLText", &r.ActionURLText)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceImpactingEvent.
func (s ServiceImpactingEvent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "correlationId", s.CorrelationID)
	populateDateTimeRFC3339(objectMap, "eventStartTime", s.EventStartTime)
	populateDateTimeRFC3339(objectMap, "eventStatusLastModifiedTime", s.EventStatusLastModifiedTime)
	populate(objectMap, "incidentProperties", s.IncidentProperties)
	populate(objectMap, "status", s.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceImpactingEvent.
func (s *ServiceImpactingEvent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &s.CorrelationID)
			delete(rawMsg, key)
		case "eventStartTime":
			err = unpopulateDateTimeRFC3339(val, "EventStartTime", &s.EventStartTime)
			delete(rawMsg, key)
		case "eventStatusLastModifiedTime":
			err = unpopulateDateTimeRFC3339(val, "EventStatusLastModifiedTime", &s.EventStatusLastModifiedTime)
			delete(rawMsg, key)
		case "incidentProperties":
			err = unpopulate(val, "IncidentProperties", &s.IncidentProperties)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceImpactingEventIncidentProperties.
func (s ServiceImpactingEventIncidentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "incidentType", s.IncidentType)
	populate(objectMap, "region", s.Region)
	populate(objectMap, "service", s.Service)
	populate(objectMap, "title", s.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceImpactingEventIncidentProperties.
func (s *ServiceImpactingEventIncidentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "incidentType":
			err = unpopulate(val, "IncidentType", &s.IncidentType)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &s.Region)
			delete(rawMsg, key)
		case "service":
			err = unpopulate(val, "Service", &s.Service)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &s.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceImpactingEventStatus.
func (s ServiceImpactingEventStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceImpactingEventStatus.
func (s *ServiceImpactingEventStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatusActiveEvent.
func (s StatusActiveEvent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cloud", s.Cloud)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "impacts", s.Impacts)
	populateDateTimeRFC3339(objectMap, "lastModifiedTime", s.LastModifiedTime)
	populate(objectMap, "published", s.Published)
	populate(objectMap, "severity", s.Severity)
	populate(objectMap, "stage", s.Stage)
	populateDateTimeRFC3339(objectMap, "startTime", s.StartTime)
	populate(objectMap, "title", s.Title)
	populate(objectMap, "trackingId", s.TrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatusActiveEvent.
func (s *StatusActiveEvent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloud":
			err = unpopulate(val, "Cloud", &s.Cloud)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "impacts":
			err = unpopulate(val, "Impacts", &s.Impacts)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedTime", &s.LastModifiedTime)
			delete(rawMsg, key)
		case "published":
			err = unpopulate(val, "Published", &s.Published)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &s.Severity)
			delete(rawMsg, key)
		case "stage":
			err = unpopulate(val, "Stage", &s.Stage)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &s.Title)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &s.TrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatusBanner.
func (s StatusBanner) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cloud", s.Cloud)
	populateDateTimeRFC3339(objectMap, "lastModifiedTime", s.LastModifiedTime)
	populate(objectMap, "message", s.Message)
	populate(objectMap, "title", s.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatusBanner.
func (s *StatusBanner) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloud":
			err = unpopulate(val, "Cloud", &s.Cloud)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedTime", &s.LastModifiedTime)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &s.Message)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &s.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Update.
func (u Update) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "summary", u.Summary)
	populateDateTimeRFC3339(objectMap, "updateDateTime", u.UpdateDateTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Update.
func (u *Update) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "summary":
			err = unpopulate(val, "Summary", &u.Summary)
			delete(rawMsg, key)
		case "updateDateTime":
			err = unpopulateDateTimeRFC3339(val, "UpdateDateTime", &u.UpdateDateTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
