//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
	"net/http"
	"net/url"
	"regexp"
)

// SourceControlSyncJobServer is a fake server for instances of the armautomation.SourceControlSyncJobClient type.
type SourceControlSyncJobServer struct {
	// Create is the fake for method SourceControlSyncJobClient.Create
	// HTTP status codes to indicate success: http.StatusCreated
	Create func(ctx context.Context, resourceGroupName string, automationAccountName string, sourceControlName string, sourceControlSyncJobID string, parameters armautomation.SourceControlSyncJobCreateParameters, options *armautomation.SourceControlSyncJobClientCreateOptions) (resp azfake.Responder[armautomation.SourceControlSyncJobClientCreateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SourceControlSyncJobClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, automationAccountName string, sourceControlName string, sourceControlSyncJobID string, options *armautomation.SourceControlSyncJobClientGetOptions) (resp azfake.Responder[armautomation.SourceControlSyncJobClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByAutomationAccountPager is the fake for method SourceControlSyncJobClient.NewListByAutomationAccountPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByAutomationAccountPager func(resourceGroupName string, automationAccountName string, sourceControlName string, options *armautomation.SourceControlSyncJobClientListByAutomationAccountOptions) (resp azfake.PagerResponder[armautomation.SourceControlSyncJobClientListByAutomationAccountResponse])
}

// NewSourceControlSyncJobServerTransport creates a new instance of SourceControlSyncJobServerTransport with the provided implementation.
// The returned SourceControlSyncJobServerTransport instance is connected to an instance of armautomation.SourceControlSyncJobClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSourceControlSyncJobServerTransport(srv *SourceControlSyncJobServer) *SourceControlSyncJobServerTransport {
	return &SourceControlSyncJobServerTransport{
		srv:                             srv,
		newListByAutomationAccountPager: newTracker[azfake.PagerResponder[armautomation.SourceControlSyncJobClientListByAutomationAccountResponse]](),
	}
}

// SourceControlSyncJobServerTransport connects instances of armautomation.SourceControlSyncJobClient to instances of SourceControlSyncJobServer.
// Don't use this type directly, use NewSourceControlSyncJobServerTransport instead.
type SourceControlSyncJobServerTransport struct {
	srv                             *SourceControlSyncJobServer
	newListByAutomationAccountPager *tracker[azfake.PagerResponder[armautomation.SourceControlSyncJobClientListByAutomationAccountResponse]]
}

// Do implements the policy.Transporter interface for SourceControlSyncJobServerTransport.
func (s *SourceControlSyncJobServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SourceControlSyncJobClient.Create":
		resp, err = s.dispatchCreate(req)
	case "SourceControlSyncJobClient.Get":
		resp, err = s.dispatchGet(req)
	case "SourceControlSyncJobClient.NewListByAutomationAccountPager":
		resp, err = s.dispatchNewListByAutomationAccountPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SourceControlSyncJobServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if s.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sourceControls/(?P<sourceControlName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sourceControlSyncJobs/(?P<sourceControlSyncJobId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armautomation.SourceControlSyncJobCreateParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	sourceControlNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sourceControlName")])
	if err != nil {
		return nil, err
	}
	sourceControlSyncJobIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("sourceControlSyncJobId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Create(req.Context(), resourceGroupNameParam, automationAccountNameParam, sourceControlNameParam, sourceControlSyncJobIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SourceControlSyncJob, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SourceControlSyncJobServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sourceControls/(?P<sourceControlName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sourceControlSyncJobs/(?P<sourceControlSyncJobId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	sourceControlNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sourceControlName")])
	if err != nil {
		return nil, err
	}
	sourceControlSyncJobIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("sourceControlSyncJobId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, automationAccountNameParam, sourceControlNameParam, sourceControlSyncJobIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SourceControlSyncJobByID, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SourceControlSyncJobServerTransport) dispatchNewListByAutomationAccountPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByAutomationAccountPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByAutomationAccountPager not implemented")}
	}
	newListByAutomationAccountPager := s.newListByAutomationAccountPager.get(req)
	if newListByAutomationAccountPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sourceControls/(?P<sourceControlName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sourceControlSyncJobs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
		if err != nil {
			return nil, err
		}
		sourceControlNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sourceControlName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armautomation.SourceControlSyncJobClientListByAutomationAccountOptions
		if filterParam != nil {
			options = &armautomation.SourceControlSyncJobClientListByAutomationAccountOptions{
				Filter: filterParam,
			}
		}
		resp := s.srv.NewListByAutomationAccountPager(resourceGroupNameParam, automationAccountNameParam, sourceControlNameParam, options)
		newListByAutomationAccountPager = &resp
		s.newListByAutomationAccountPager.add(req, newListByAutomationAccountPager)
		server.PagerResponderInjectNextLinks(newListByAutomationAccountPager, req, func(page *armautomation.SourceControlSyncJobClientListByAutomationAccountResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByAutomationAccountPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByAutomationAccountPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByAutomationAccountPager) {
		s.newListByAutomationAccountPager.remove(req)
	}
	return resp, nil
}
