//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
	"net/http"
	"net/url"
	"regexp"
)

// NotificationRecipientEmailServer is a fake server for instances of the armapimanagement.NotificationRecipientEmailClient type.
type NotificationRecipientEmailServer struct {
	// CheckEntityExists is the fake for method NotificationRecipientEmailClient.CheckEntityExists
	// HTTP status codes to indicate success: http.StatusNoContent, http.StatusNotFound
	CheckEntityExists func(ctx context.Context, resourceGroupName string, serviceName string, notificationName armapimanagement.NotificationName, email string, options *armapimanagement.NotificationRecipientEmailClientCheckEntityExistsOptions) (resp azfake.Responder[armapimanagement.NotificationRecipientEmailClientCheckEntityExistsResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdate is the fake for method NotificationRecipientEmailClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, serviceName string, notificationName armapimanagement.NotificationName, email string, options *armapimanagement.NotificationRecipientEmailClientCreateOrUpdateOptions) (resp azfake.Responder[armapimanagement.NotificationRecipientEmailClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method NotificationRecipientEmailClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, serviceName string, notificationName armapimanagement.NotificationName, email string, options *armapimanagement.NotificationRecipientEmailClientDeleteOptions) (resp azfake.Responder[armapimanagement.NotificationRecipientEmailClientDeleteResponse], errResp azfake.ErrorResponder)

	// ListByNotification is the fake for method NotificationRecipientEmailClient.ListByNotification
	// HTTP status codes to indicate success: http.StatusOK
	ListByNotification func(ctx context.Context, resourceGroupName string, serviceName string, notificationName armapimanagement.NotificationName, options *armapimanagement.NotificationRecipientEmailClientListByNotificationOptions) (resp azfake.Responder[armapimanagement.NotificationRecipientEmailClientListByNotificationResponse], errResp azfake.ErrorResponder)
}

// NewNotificationRecipientEmailServerTransport creates a new instance of NotificationRecipientEmailServerTransport with the provided implementation.
// The returned NotificationRecipientEmailServerTransport instance is connected to an instance of armapimanagement.NotificationRecipientEmailClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewNotificationRecipientEmailServerTransport(srv *NotificationRecipientEmailServer) *NotificationRecipientEmailServerTransport {
	return &NotificationRecipientEmailServerTransport{srv: srv}
}

// NotificationRecipientEmailServerTransport connects instances of armapimanagement.NotificationRecipientEmailClient to instances of NotificationRecipientEmailServer.
// Don't use this type directly, use NewNotificationRecipientEmailServerTransport instead.
type NotificationRecipientEmailServerTransport struct {
	srv *NotificationRecipientEmailServer
}

// Do implements the policy.Transporter interface for NotificationRecipientEmailServerTransport.
func (n *NotificationRecipientEmailServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "NotificationRecipientEmailClient.CheckEntityExists":
		resp, err = n.dispatchCheckEntityExists(req)
	case "NotificationRecipientEmailClient.CreateOrUpdate":
		resp, err = n.dispatchCreateOrUpdate(req)
	case "NotificationRecipientEmailClient.Delete":
		resp, err = n.dispatchDelete(req)
	case "NotificationRecipientEmailClient.ListByNotification":
		resp, err = n.dispatchListByNotification(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (n *NotificationRecipientEmailServerTransport) dispatchCheckEntityExists(req *http.Request) (*http.Response, error) {
	if n.srv.CheckEntityExists == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckEntityExists not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/notifications/(?P<notificationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recipientEmails/(?P<email>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	notificationNameParam, err := parseWithCast(matches[regex.SubexpIndex("notificationName")], func(v string) (armapimanagement.NotificationName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armapimanagement.NotificationName(p), nil
	})
	if err != nil {
		return nil, err
	}
	emailParam, err := url.PathUnescape(matches[regex.SubexpIndex("email")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := n.srv.CheckEntityExists(req.Context(), resourceGroupNameParam, serviceNameParam, notificationNameParam, emailParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent, http.StatusNotFound}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent, http.StatusNotFound", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (n *NotificationRecipientEmailServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if n.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/notifications/(?P<notificationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recipientEmails/(?P<email>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	notificationNameParam, err := parseWithCast(matches[regex.SubexpIndex("notificationName")], func(v string) (armapimanagement.NotificationName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armapimanagement.NotificationName(p), nil
	})
	if err != nil {
		return nil, err
	}
	emailParam, err := url.PathUnescape(matches[regex.SubexpIndex("email")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := n.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, serviceNameParam, notificationNameParam, emailParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RecipientEmailContract, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (n *NotificationRecipientEmailServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if n.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/notifications/(?P<notificationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recipientEmails/(?P<email>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	notificationNameParam, err := parseWithCast(matches[regex.SubexpIndex("notificationName")], func(v string) (armapimanagement.NotificationName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armapimanagement.NotificationName(p), nil
	})
	if err != nil {
		return nil, err
	}
	emailParam, err := url.PathUnescape(matches[regex.SubexpIndex("email")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := n.srv.Delete(req.Context(), resourceGroupNameParam, serviceNameParam, notificationNameParam, emailParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (n *NotificationRecipientEmailServerTransport) dispatchListByNotification(req *http.Request) (*http.Response, error) {
	if n.srv.ListByNotification == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListByNotification not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/notifications/(?P<notificationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recipientEmails`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	notificationNameParam, err := parseWithCast(matches[regex.SubexpIndex("notificationName")], func(v string) (armapimanagement.NotificationName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armapimanagement.NotificationName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := n.srv.ListByNotification(req.Context(), resourceGroupNameParam, serviceNameParam, notificationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RecipientEmailCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
